ENV["RAILS_ENV"] = "test"
require File.expand_path(File.dirname(__FILE__) + "/../config/environment")
require 'test_help'

class Test::Unit::TestCase
  # Transactional fixtures accelerate your tests by wrapping each test method
  # in a transaction that's rolled back on completion.  This ensures that the
  # test database remains unchanged so your fixtures don't have to be reloaded
  # between every test method.  Fewer database queries means faster tests.
  #
  # Read Mike Clark's excellent walkthrough at
  #   http://clarkware.com/cgi/blosxom/2005/10/24#Rails10FastTesting
  #
  # Every Active Record database supports transactions except MyISAM tables
  # in MySQL.  Turn off transactional fixtures in this case; however, if you
  # don't care one way or the other, switching from MyISAM to InnoDB tables
  # is recommended.
  self.use_transactional_fixtures = false

  # Instantiated fixtures are slow, but give you @david where otherwise you
  # would need people(:david).  If you don't want to migrate your existing
  # test cases which use the @david style and don't mind the speed hit (each
  # instantiated fixtures translates to a database query per test method),
  # then set this back to true.
  self.use_instantiated_fixtures  = false

  # Add more helper methods to be used by all tests here...
  
  def signin
    get '/'
    session[:user_id] = users(:alice).id
  end

  module PostsTestHelpers

    def self.included klass
      klass.fixtures :posts, :users
      klass.assert_valid_markup :index, :new
    end

    def setup2
      @request  = ActionController::TestRequest.new
      @response = ActionController::TestResponse.new
      signin
    end

    def test_create
      post :create, 'post' => posts(@post_type).attributes
      assert_redirected_to :action => 'index'
    end
    
    def test_show
      get :show, :id => posts(@post_type).id
      assert_valid_markup
    end
    
    def test_edit
      get :edit, :id => posts(@post_type).id
      assert_valid_markup
    end
    
    def test_update
      post :update, 'id' => posts(@post_type).id, 'post' => posts(@post_type).attributes
      assert_redirected_to :action => 'show'
    end
    
    def test_delete
      delete :destroy, :id => posts(@post_type).id
      assert_redirected_to :action => 'index'
    end

  end
  
end
